// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package ksp.com.intellij.psi.impl.file;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiDirectoryContainer;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.PsiManagerImpl;
import ksp.org.jetbrains.annotations.NotNull;


public final class PsiDirectoryFactoryImpl extends PsiDirectoryFactory {
  private final Project myProject;

  public PsiDirectoryFactoryImpl(@NotNull Project project) {
    myProject = project;
  }
  @Override
  public @NotNull PsiDirectory createDirectory(@NotNull VirtualFile file) {
    return new PsiDirectoryImpl((PsiManagerImpl)PsiManager.getInstance(myProject), file);
  }

  @Override
  public @NotNull String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
    if (presentable) {
      return FileUtil.getLocationRelativeToUserHome(directory.getVirtualFile().getPresentableUrl());
    }
    return "";
  }

  @Override
  public PsiDirectoryContainer getDirectoryContainer(@NotNull PsiDirectory directory) {
    return null;
  }

  @Override
  public boolean isPackage(@NotNull PsiDirectory directory) {
    return false;
  }

  @Override
  public boolean isValidPackageName(String name) {
    return true;
  }
}
