/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.imports

import ksp.com.intellij.openapi.components.service
import ksp.com.intellij.openapi.project.Project
import ksp.org.jetbrains.kotlin.analysis.api.KaIdeApi
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.platform.TargetPlatform

/**
 * Provides a list of default imports for a specific [TargetPlatform].
 */
@KaIdeApi
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaDefaultImportsProvider {
    /**
     * @see org.jetbrains.kotlin.analysis.api.imports.getDefaultImports
     */
    public fun getDefaultImports(targetPlatform: TargetPlatform): KaDefaultImports

    @KaIdeApi
    public companion object {
        public fun getService(project: Project): KaDefaultImportsProvider =
            project.service()
    }
}

/**
 * Provides a list of default imports for a specific [TargetPlatform].
 *
 * This list may vary for each platform.
 * See the [documentation page](https://kotlinlang.org/docs/packages.html#default-imports) for details.
 *
 * Some declarations imported by default are excluded; see [KaDefaultImports.excludedFromDefaultImports].
 */
@KaIdeApi
public fun TargetPlatform.getDefaultImports(project: Project): KaDefaultImports =
    KaDefaultImportsProvider.getService(project).getDefaultImports(this)
