/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.asJava.classes

import ksp.com.intellij.psi.PsiClass
import ksp.com.intellij.psi.impl.source.PsiExtensibleClass
import ksp.org.jetbrains.kotlin.asJava.KtLightClassMarker
import ksp.org.jetbrains.kotlin.asJava.elements.KtLightDeclaration
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject

interface KtLightClass : PsiClass, KtLightDeclaration<KtClassOrObject, PsiClass>, KtLightClassMarker

interface KtExtensibleLightClass : KtLightClass, PsiExtensibleClass