/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi

import ksp.com.intellij.lang.ASTNode
import ksp.org.jetbrains.kotlin.KtStubBasedElementTypes
import ksp.org.jetbrains.kotlin.psi.psiUtil.getChildOfType
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinContractEffectStub

class KtContractEffect: KtElementImplStub<KotlinContractEffectStub> {
    constructor(node: ASTNode): super(node)
    constructor(stub: KotlinContractEffectStub): super(stub, KtStubBasedElementTypes.CONTRACT_EFFECT)
}

fun KtContractEffect.getExpression(): KtExpression = getChildOfType()!!
