// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.codeWithMe

import ksp.com.intellij.openapi.diagnostic.Logger

public fun ClientId.isCurrent(): Boolean {
  return this == ClientId.current
}

fun ClientId.assertClientIdConsistency(message: String) {
  if (this != ClientId.current) {
    Logger.getInstance(ClientId::class.java).error("$message ClientId=${this} doesn't match Current=${ClientId.current}")
  }
}
