// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.core;

import ksp.com.intellij.DynamicBundle;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.PropertyKey;

import java.util.function.Supplier;

public final class JavaOptionBundle {
  public static final @NonNls String BUNDLE = "messages.JavaOptionBundle";
  public static final DynamicBundle INSTANCE = new DynamicBundle(JavaOptionBundle.class, BUNDLE);

  private JavaOptionBundle() { }

  public static @NotNull @Nls String message(@NotNull @PropertyKey(resourceBundle = BUNDLE) String key, Object @NotNull ... params) {
    return INSTANCE.getMessage(key, params);
  }

  public static @NotNull Supplier<@Nls String> messagePointer(@NotNull @PropertyKey(resourceBundle = BUNDLE) String key, Object @NotNull ... params) {
    return INSTANCE.getLazyMessage(key, params);
  }

  public static boolean contains(String key) {
    return INSTANCE.containsKey(key);
  }
}