// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.ide.plugins

import ksp.com.intellij.openapi.progress.ProcessCanceledException
import ksp.com.intellij.util.messages.Topic

class CannotUnloadPluginException(value: String) : ProcessCanceledException(RuntimeException(value))

interface DynamicPluginListener {
  companion object {
    @JvmField
    @Topic.AppLevel
    val TOPIC: Topic<DynamicPluginListener> = Topic(DynamicPluginListener::class.java, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true)
  }

  fun beforePluginLoaded(pluginDescriptor: IdeaPluginDescriptor) {
  }

  fun pluginLoaded(pluginDescriptor: IdeaPluginDescriptor) {
  }

  /**
   * @param isUpdate `true` if the plugin is being unloaded as part of an update installation and a new version will be loaded afterwards
   */
  fun beforePluginUnload(pluginDescriptor: IdeaPluginDescriptor, isUpdate: Boolean) {
  }

  fun pluginUnloaded(pluginDescriptor: IdeaPluginDescriptor, isUpdate: Boolean) {
  }

  /**
   * Checks if the plugin can be dynamically unloaded at this moment.
   * Method should throw [CannotUnloadPluginException] if it isn't possible for some reason.
   *
   * Not dispatched for a content modules (plugin model V2).
   */
  @Throws(CannotUnloadPluginException::class)
  fun checkUnloadPlugin(pluginDescriptor: IdeaPluginDescriptor) {
  }
}