// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.lang.java.parser;

import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementTypeFactory;
import ksp.org.jetbrains.annotations.NotNull;

public final class JavadocParser {

  private JavadocParser() { }

  public static void parseJavadocReference(@NotNull PsiBuilder builder) {
    BasicJavaDocParser.parseJavadocReference(builder, JavaParser.INSTANCE);
  }

  public static void parseJavadocType(@NotNull PsiBuilder builder) {
    BasicJavaDocParser.parseJavadocType(builder, JavaParser.INSTANCE);
  }

  public static void parseDocCommentText(@NotNull PsiBuilder builder) {
    BasicJavaDocParser.parseDocCommentText(builder, JavaDocElementTypeFactory.INSTANCE.getContainer());
  }
}