// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.model.presentation;

import ksp.com.intellij.model.psi.PsiSymbolDeclaration;
import ksp.com.intellij.openapi.util.ClassExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface SymbolDeclarationPresentationProvider<D extends PsiSymbolDeclaration> {

  ClassExtension<SymbolDeclarationPresentationProvider> EP = new ClassExtension<>("com.intellij.symbolDeclarationPresentationProvider");

  /**
   * @see SymbolDeclarationPresentation#getFor
   */
  @Nullable SymbolDeclarationPresentation getPresentation(@NotNull D symbolDeclaration);
}
