// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

/*
 * @author max
 */
package ksp.com.intellij.openapi.fileTypes;

import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lang.PsiParser;
import ksp.com.intellij.lexer.EmptyLexer;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PlainTextTokenTypes;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.org.jetbrains.annotations.NotNull;

public class PlainTextParserDefinition implements ParserDefinition {
  private static final IFileElementType PLAIN_FILE_ELEMENT_TYPE = new IFileElementType(PlainTextFileType.INSTANCE.getLanguage()) {
    @Override
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
      final CharSequence chars = chameleon.getChars();
      return ASTFactory.leaf(PlainTextTokenTypes.PLAIN_TEXT, chars);
    }
  };

  @Override
  public @NotNull Lexer createLexer(Project project) {
    return new EmptyLexer();
  }

  @Override
  public @NotNull PsiParser createParser(Project project) {
    throw new UnsupportedOperationException("Not supported");
  }

  @Override
  public @NotNull IFileElementType getFileNodeType() {
    return PLAIN_FILE_ELEMENT_TYPE;
  }

  @Override
  public @NotNull TokenSet getWhitespaceTokens() {
    return TokenSet.EMPTY;
  }

  @Override
  public @NotNull TokenSet getCommentTokens() {
    return TokenSet.EMPTY;
  }

  @Override
  public @NotNull TokenSet getStringLiteralElements() {
    return TokenSet.EMPTY;
  }

  @Override
  public @NotNull PsiElement createElement(ASTNode node) {
    return PsiUtilCore.NULL_PSI_ELEMENT;
  }

  @Override
  public @NotNull PsiFile createFile(@NotNull FileViewProvider viewProvider) {
    return new PsiPlainTextFileImpl(viewProvider);
  }

  @Override
  public @NotNull SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
    return SpaceRequirements.MAY;
  }
}
