// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.pom;

import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.Consumer;
import ksp.com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock;
import ksp.org.jetbrains.annotations.NotNull;

/**
 * Implement this interface and register the implementation as {@code com.intellij.pom.declarationSearcher} extension in plugin.xml
 * to provide {@link PomTarget POM targets}.
 *
 * @see com.intellij.model.psi.PsiSymbolDeclarationProvider
 */
public abstract class PomDeclarationSearcher {

  public static final ExtensionPointName<PomDeclarationSearcher> EP_NAME = ExtensionPointName.create(
    "com.intellij.pom.declarationSearcher"
  );

  /**
   * @param element         potential target host
   * @param offsetInElement offset relative to {@code offset.getTextRange().getStartOffset()}
   * @param consumer        consumer of targets, not thread-safe, only the first target will be used
   */
  @RequiresReadLock
  @RequiresBackgroundThread
  public abstract void findDeclarationsAt(@NotNull PsiElement element, int offsetInElement, @NotNull Consumer<? super PomTarget> consumer);
}
