// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.pom.impl;

import ksp.com.intellij.pom.PomManager;
import ksp.com.intellij.pom.PomTransaction;
import ksp.com.intellij.pom.event.PomModelEvent;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public abstract class PomTransactionBase implements PomTransaction{
  private final PsiElement myScope;
  private final PomModelEvent myAccumulatedEvent;
  public PomTransactionBase(@NotNull PsiElement scope) {
    myScope = scope;
    myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope.getProject()), null);
  }

  @Override
  public @NotNull PomModelEvent getAccumulatedEvent() {
    return myAccumulatedEvent;
  }

  @Override
  public void run() throws IncorrectOperationException {
    myAccumulatedEvent.merge(runInner());
  }

  public abstract @NotNull PomModelEvent runInner() throws IncorrectOperationException;

  @Override
  public @NotNull PsiElement getChangeScope() {
    return myScope;
  }

}
