// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package ksp.com.intellij.psi;

import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.fileTypes.PlainTextLanguage;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.org.jetbrains.annotations.NotNull;

public final class PlainTextTokenTypes {
  public static final IElementType PLAIN_TEXT_FILE = new IFileElementType("PLAIN_TEXT_FILE", PlainTextLanguage.INSTANCE) {
    @Override
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
      return ASTFactory.leaf(PLAIN_TEXT, chameleon.getChars());
    }
  };

  public static final IElementType PLAIN_TEXT = new IElementType("PLAIN_TEXT", PlainTextLanguage.INSTANCE);

  private PlainTextTokenTypes() {
  }
}
