// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IReparseableLeafElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

class WhiteSpaceTokenType extends IElementType implements IReparseableLeafElementType<ASTNode> {
  WhiteSpaceTokenType() {
    super("WHITE_SPACE", Language.ANY);
  }

  @Override
  public @Nullable ASTNode reparseLeaf(@NotNull ASTNode leaf, @NotNull CharSequence newText) {
    Language contextLanguage = leaf.getPsi().getLanguage();
    if (contextLanguage == Language.ANY) {
      return null;
    }

    ParserDefinition parserDefinition = LanguageParserDefinitions.INSTANCE.forLanguage(contextLanguage);
    if (parserDefinition == null) {
      return null;
    }

    for (int i = 0; i < newText.length(); i++) {
      if (!Character.isWhitespace(newText.charAt(i))) {
        return null;
      }
    }

    return parserDefinition.reparseSpace(leaf, newText);
  }
}
