// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiRecordHeader;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiRecordHeaderStubImpl;
import ksp.com.intellij.psi.impl.source.BasicJavaElementType;
import ksp.com.intellij.psi.impl.source.PsiRecordHeaderImpl;
import ksp.com.intellij.psi.impl.source.tree.java.RecordHeaderElement;
import ksp.com.intellij.psi.stubs.*;
import ksp.org.jetbrains.annotations.NotNull;

public class JavaRecordHeaderElementType extends JavaStubElementType<PsiRecordHeaderStub, PsiRecordHeader>
  implements EmptyStubSerializer<PsiRecordHeaderStub> {
  public JavaRecordHeaderElementType() {
    super("RECORD_HEADER", BasicJavaElementType.BASIC_RECORD_HEADER);
  }

  @NotNull
  @Override
  public ASTNode createCompositeNode() {
    return new RecordHeaderElement();
  }

  @NotNull
  @Override
  public PsiRecordHeaderStub instantiate(StubElement parentStub) {
    return new PsiRecordHeaderStubImpl(parentStub);
  }

  @Override
  public void indexStub(@NotNull PsiRecordHeaderStub stub, @NotNull IndexSink sink) {

  }

  @Override
  public PsiRecordHeader createPsi(@NotNull PsiRecordHeaderStub stub) {
    return getPsiFactory(stub).createRecordHeader(stub);
  }


  @Override
  public PsiRecordHeader createPsi(@NotNull ASTNode node) {
    return new PsiRecordHeaderImpl(node);
  }

  @NotNull
  @Override
  public PsiRecordHeaderStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
    return new PsiRecordHeaderStubImpl(parentStub);
  }
}