// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiTypeParameterList;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import ksp.com.intellij.psi.impl.source.BasicJavaElementType;
import ksp.com.intellij.psi.impl.source.tree.java.PsiTypeParameterListImpl;
import ksp.com.intellij.psi.impl.source.tree.java.TypeParameterListElement;
import ksp.com.intellij.psi.stubs.*;
import ksp.org.jetbrains.annotations.NotNull;

public class JavaTypeParameterListElementType extends JavaStubElementType<PsiTypeParameterListStub, PsiTypeParameterList>
  implements EmptyStubSerializer<PsiTypeParameterListStub> {
  public JavaTypeParameterListElementType() {
    super("TYPE_PARAMETER_LIST", true, BasicJavaElementType.BASIC_TYPE_PARAMETER_LIST);
  }

  @NotNull
  @Override
  public ASTNode createCompositeNode() {
    return new TypeParameterListElement();
  }

  @Override
  public PsiTypeParameterList createPsi(@NotNull final PsiTypeParameterListStub stub) {
    return getPsiFactory(stub).createTypeParameterList(stub);
  }

  @Override
  public PsiTypeParameterList createPsi(@NotNull final ASTNode node) {
    return new PsiTypeParameterListImpl(node);
  }

  @NotNull
  @Override
  public PsiTypeParameterListStub createStub(@NotNull final LighterAST tree,
                                             @NotNull final LighterASTNode node,
                                             final @NotNull StubElement<?> parentStub) {
    return new PsiTypeParameterListStubImpl(parentStub);
  }

  @NotNull
  @Override
  public PsiTypeParameterListStub instantiate(final StubElement parentStub) {
    return new PsiTypeParameterListStubImpl(parentStub);
  }

  @Override
  public void indexStub(@NotNull final PsiTypeParameterListStub stub, @NotNull final IndexSink sink) {
  }
}
