/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * @author max
 */
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiReferenceList;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.org.jetbrains.annotations.NotNull;

public interface PsiClassReferenceListStub extends StubElement<PsiReferenceList> {
  /**
   * @return types
   */
  PsiClassType @NotNull [] getReferencedTypes();

  /**
   * @return type names
   */
  String @NotNull [] getReferencedNames();

  /**
   * @return array of TypeInfo objects
   */
  @NotNull TypeInfo @NotNull [] getTypes();
  
  @NotNull PsiReferenceList.Role getRole();
}