// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.source;

import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

interface ClassReferencePointer {
  @Nullable
  PsiJavaCodeReferenceElement retrieveReference();

  @NotNull
  PsiJavaCodeReferenceElement retrieveNonNullReference();

  static ClassReferencePointer constant(@NotNull PsiJavaCodeReferenceElement ref) {
    return new ClassReferencePointer() {
      @NotNull
      @Override
      public PsiJavaCodeReferenceElement retrieveReference() {
        return ref;
      }

      @NotNull
      @Override
      public PsiJavaCodeReferenceElement retrieveNonNullReference() {
        return ref;
      }
    };
  }

}
