// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package ksp.com.intellij.psi.impl.source.resolve.reference;

import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReferenceProvider;
import ksp.com.intellij.psi.PsiReferenceService;
import ksp.com.intellij.util.ProcessingContext;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.List;

public interface ProviderBinding {
  class ProviderInfo<Context> {
    public final @NotNull PsiReferenceProvider provider;
    public final @NotNull Context processingContext;
    public final double priority;

    public ProviderInfo(@NotNull PsiReferenceProvider provider, @NotNull Context processingContext, double priority) {
      this.provider = provider;
      this.processingContext = processingContext;
      this.priority = priority;
    }

    @Override
    public String toString() {
      return "ProviderInfo{provider=" + provider + ", priority=" + priority + '}';
    }
  }
  void addAcceptableReferenceProviders(@NotNull PsiElement position,
                                       @NotNull List<? super ProviderInfo<ProcessingContext>> list,
                                       @NotNull PsiReferenceService.Hints hints);

  void unregisterProvider(@NotNull PsiReferenceProvider provider);
}
