
// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package ksp.com.intellij.psi.impl.source.tree;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.com.intellij.psi.*;
import ksp.com.intellij.psi.templateLanguages.OuterLanguageElement;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiErrorElementImpl extends CompositePsiElement implements PsiErrorElement{
  private final @NlsContexts.DetailedDescription String myErrorDescription;

  public PsiErrorElementImpl(@NotNull @NlsContexts.DetailedDescription String errorDescription) {
    super(TokenType.ERROR_ELEMENT);
    myErrorDescription = errorDescription;
  }

  @Override
  public @NotNull String getErrorDescription() {
    return myErrorDescription;
  }

  @Override
  public void accept(@NotNull PsiElementVisitor visitor){
    visitor.visitErrorElement(this);
  }

  @Override
  public String toString(){
    return "PsiErrorElement:" + getErrorDescription();
  }

  @Override
  public @NotNull Language getLanguage() {
    PsiElement master = this;
    while (true) {
      master = master.getNextSibling();
      if (master == null || master instanceof OuterLanguageElement) {
        PsiElement parent = getParent();
        return parent == null ? Language.ANY : parent.getLanguage();
      }
      if (master instanceof PsiWhiteSpace || master instanceof PsiErrorElement) continue;
      return master.getLanguage();
    }
  }
}