// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.stub;

import ksp.com.intellij.psi.PsiJavaDocumentedElement;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.PsiMethodImpl;
import ksp.com.intellij.psi.impl.source.StubbedSpine;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JavaStubImplUtil {
  public static int getMethodStubIndex(PsiMethod method) {
    if (!(method instanceof PsiMethodImpl)) return -1;
    PsiFileImpl file = (PsiFileImpl)method.getContainingFile();
    StubbedSpine spine = file.getStubbedSpine();

    int result = 0;
    for (int i = 0; i < spine.getStubCount(); i++) {
      if (spine.getStubType(i) == JavaElementType.METHOD) {
        if (spine.getStubPsi(i) == method) {
          return result;
        }
        result++;
      }
    }
    return -1;
  }

  public static <T extends PsiMember & PsiJavaDocumentedElement> boolean isMemberDeprecated(@NotNull T member,
                                                                                            @Nullable PsiMemberStub<?> stub) {
    if (stub != null) {
      return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(member);
    }

    return PsiImplUtil.isDeprecatedByDocTag(member) || PsiImplUtil.isDeprecatedByAnnotation(member);
  }
}
