/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.platform.utils

import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.PsiElementFinder

public inline fun forEachNonKotlinPsiElementFinder(project: Project, action: (PsiElementFinder) -> Unit) {
    for (finder in PsiElementFinder.EP.getPoint(project).extensionList) {
        if (finder::class.java.name == KOTLIN_JAVA_ELEMENT_FINDER_CLASS_NAME) {
            continue
        }
        action(finder)
    }
}

public const val KOTLIN_JAVA_ELEMENT_FINDER_CLASS_NAME: String = "org.jetbrains.kotlin.asJava.finder.JavaElementFinder"
