/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.standalone.base.java

import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaNonPublicApi
import ksp.org.jetbrains.kotlin.analysis.api.platform.java.KotlinJavaModuleJavaAnnotationsProvider
import ksp.org.jetbrains.kotlin.load.java.structure.JavaAnnotation
import ksp.org.jetbrains.kotlin.name.ClassId
import ksp.org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver

/**
 * Delegates directly to the compiler's [JavaModuleResolver] as we can use it in Standalone.
 *
 * Inheriting from [KotlinJavaModuleJavaAnnotationsProvider] allows the component to provide [JavaAnnotation]s directly, without having to
 * convert them to PSI annotations (and then another conversion of those PSI annotations back into [JavaAnnotation] in
 * `KaBaseJavaModuleResolver`).
 */
@OptIn(KaNonPublicApi::class)
@KaImplementationDetail
class KotlinStandaloneJavaModuleAnnotationsProvider(
    private val javaModuleResolver: JavaModuleResolver,
) : KotlinJavaModuleJavaAnnotationsProvider {
    override fun getAnnotationsForModuleOwnerOfClass(classId: ClassId): List<JavaAnnotation>? =
        javaModuleResolver.getAnnotationsForModuleOwnerOfClass(classId)
}
