/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir

import ksp.com.intellij.openapi.roots.ProjectRootModificationTracker
import ksp.com.intellij.psi.util.PsiModificationTracker
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.DiagnosticsCollector
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilder
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.LLFirFileBuilder
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCacheImpl
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.LLFirModuleLazyDeclarationResolver
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSession
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLFirScopeSessionProvider
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule
import ksp.org.jetbrains.kotlin.fir.scopes.FirScopeProvider

internal class LLFirModuleResolveComponents(
    val module: KaModule,
    val globalResolveComponents: LLFirGlobalResolveComponents,
    val scopeProvider: FirScopeProvider
) {
    val cache: ModuleFileCache = ModuleFileCacheImpl(this)
    val firFileBuilder: LLFirFileBuilder = LLFirFileBuilder(this)
    val firModuleLazyDeclarationResolver = LLFirModuleLazyDeclarationResolver(this)

    val scopeSessionProvider: LLFirScopeSessionProvider = LLFirScopeSessionProvider.create(
        globalResolveComponents.project,
        invalidationTrackers = listOf(
            PsiModificationTracker.MODIFICATION_COUNT,
            ProjectRootModificationTracker.getInstance(globalResolveComponents.project),
        )
    )

    val fileStructureCache: FileStructureCache = FileStructureCache(this)
    val elementsBuilder = FirElementBuilder(this)
    val diagnosticsCollector = DiagnosticsCollector(fileStructureCache)

    lateinit var session: LLFirResolvableModuleSession
}