/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions

import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.moduleData
import ksp.org.jetbrains.kotlin.fir.FirModuleData
import ksp.org.jetbrains.kotlin.fir.java.FirJavaFacade
import ksp.org.jetbrains.kotlin.load.java.JavaClassFinder
import ksp.org.jetbrains.kotlin.load.java.structure.JavaClass

internal class LLFirJavaFacadeForBinaries(
    private val session: LLFirSession,
    classFinder: JavaClassFinder,
) : FirJavaFacade(session, classFinder) {
    override fun getModuleDataForClass(javaClass: JavaClass): FirModuleData = session.moduleData
}
