/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.build.report.metrics

import java.io.Serializable
import java.util.*

class BuildPerformanceMetrics<T: BuildPerformanceMetric> : Serializable {
    companion object {
        const val serialVersionUID = 0L
    }

    private val myBuildMetrics = HashMap<T, Long>()

    fun addAll(other: BuildPerformanceMetrics<T>) {
        for ((bt, value) in other.myBuildMetrics) {
            addLong(bt, value)
        }
    }

    fun addLong(metric: T, value: Long = 1) {
        myBuildMetrics[metric] = myBuildMetrics.getOrDefault(metric, 0) + value
    }

    fun asMap(): Map<T, Long> = myBuildMetrics

}