/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.extensions

import ksp.com.intellij.core.CoreApplicationEnvironment
import ksp.com.intellij.openapi.Disposable
import ksp.com.intellij.openapi.application.ApplicationManager
import ksp.com.intellij.openapi.extensions.ExtensionPointName

open class ApplicationExtensionDescriptor<T : Any>(name: String, private val extensionClass: Class<T>) {
    private val extensionPointName: ExtensionPointName<T> = ExtensionPointName.create(name)

    fun registerExtensionPoint() {
        CoreApplicationEnvironment.registerExtensionPoint(
            ApplicationManager.getApplication().extensionArea,
            extensionPointName.name,
            extensionClass
        )
    }

    fun registerExtension(extension: T, disposable: Disposable) {
        ApplicationManager.getApplication().extensionArea.getExtensionPoint(extensionPointName).registerExtension(extension, disposable)
    }

    fun getInstances(): List<T> {
        val projectArea = ApplicationManager.getApplication().extensionArea
        if (!projectArea.hasExtensionPoint(extensionPointName.name)) return listOf()

        return projectArea.getExtensionPoint(extensionPointName).extensions.toList()
    }
}
