/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.collectors.components

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckersDiagnosticComponent
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.ExpressionCheckersDiagnosticComponent
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.TypeCheckersDiagnosticComponent
import ksp.org.jetbrains.kotlin.fir.analysis.collectors.DiagnosticCollectorComponents
import ksp.org.jetbrains.kotlin.fir.analysis.collectors.CliDiagnosticsCollector
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession

object DiagnosticComponentsFactory {
    private fun createAllDiagnosticComponents(
        session: FirSession,
        reporter: DiagnosticReporter,
        mppKind: MppCheckerKind,
    ): DiagnosticCollectorComponents {
        val regularComponents = buildList {
            add(DeclarationCheckersDiagnosticComponent(session, reporter, mppKind))
            add(ExpressionCheckersDiagnosticComponent(session, reporter, mppKind))
            add(TypeCheckersDiagnosticComponent(session, reporter, mppKind))
            add(ControlFlowAnalysisDiagnosticComponent(session, reporter, mppKind))
            if (mppKind == MppCheckerKind.Common) {
                add(ErrorNodeDiagnosticCollectorComponent(session, reporter))
                add(LanguageVersionSettingsDiagnosticComponent(session, reporter))
            }
        }.toTypedArray()
        return DiagnosticCollectorComponents(regularComponents, ReportCommitterDiagnosticComponent(session, reporter))
    }

    fun create(
        session: FirSession,
        scopeSession: ScopeSession,
        mppKind: MppCheckerKind
    ): CliDiagnosticsCollector {
        return CliDiagnosticsCollector(session, scopeSession) { reporter ->
            createAllDiagnosticComponents(session, reporter, mppKind)
        }
    }
}
