/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers

import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.analysis.web.common.checkers.FirAbstractWebCheckerUtils
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol

object FirJsWebCheckerUtils : FirAbstractWebCheckerUtils() {
    override fun isNativeOrExternalInterface(symbol: FirBasedSymbol<*>, session: FirSession): Boolean {
        return symbol.isNativeInterface(session)
    }
}