/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers

import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirDynamicUnsupportedChecker
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirFunctionTypeRefChecker
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirResolvedTypeRefChecker
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.TypeCheckers
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.type.FirArrayOfNullableNothingTypeChecker
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.type.FirFunctionalTypeParameterNameChecker
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.type.FirJvmModuleAccessibilityTypeChecker

object JvmTypeCheckers : TypeCheckers() {
    override val functionTypeRefCheckers: Set<FirFunctionTypeRefChecker> = setOf(
        FirFunctionalTypeParameterNameChecker,
    )

    override val resolvedTypeRefCheckers: Set<FirResolvedTypeRefChecker> = setOf(
        FirDynamicUnsupportedChecker,
        FirJvmModuleAccessibilityTypeChecker,
        FirArrayOfNullableNothingTypeChecker,
    )
}
