/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

package ksp.org.jetbrains.kotlin.fir.expressions

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.FirElement
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor

/**
 * ### Up to and including body resolution phase
 *
 * Represents a spread expression `*foo`. If a spread expression is passed as named argument `foo = *bar`, it will be
 * represented as an [FirNamedArgumentExpression] with [FirNamedArgumentExpression.isSpread] set to `true`.
 *
 * ### After body resolution phase
 *
 * Represents spread expressions `*foo` and named argument expressions for vararg parameters `foo = bar` and `foo = *bar`.
 *
 * If [isNamed] is `true`, it means the argument was passed in named form. The name is not saved since it's not required.
 * To retrieve the argument mapping of a call, [FirResolvedArgumentList.mapping] must be used.
 *
 * If [isFakeSpread] is `true`, it means this expression is the argument to a `vararg` parameter that was passed in named form
 * without a spread operator `*`.
 *
 * The information carried by [isNamed] and [isFakeSpread] is only relevant for some checkers. Otherwise,
 * [FirSpreadArgumentExpression]s should be treated uniformly since they always represent an array that was passed to a
 * `vararg` parameter and don't influence the resulting platform code.
 *
 * Generated from: [org.jetbrains.kotlin.fir.tree.generator.FirTree.spreadArgumentExpression]
 */
abstract class FirSpreadArgumentExpression : FirWrappedArgumentExpression() {
    abstract override val source: KtSourceElement?
    @UnresolvedExpressionTypeAccess
    abstract override val coneTypeOrNull: ConeKotlinType?
    abstract override val annotations: List<FirAnnotation>
    abstract override val expression: FirExpression
    abstract override val isSpread: Boolean
    abstract val isNamed: Boolean
    abstract val isFakeSpread: Boolean

    override fun <R, D> accept(visitor: FirVisitor<R, D>, data: D): R =
        visitor.visitSpreadArgumentExpression(this, data)

    @Suppress("UNCHECKED_CAST")
    override fun <E : FirElement, D> transform(transformer: FirTransformer<D>, data: D): E =
        transformer.transformSpreadArgumentExpression(this, data) as E

    abstract override fun replaceConeTypeOrNull(newConeTypeOrNull: ConeKotlinType?)

    abstract override fun replaceAnnotations(newAnnotations: List<FirAnnotation>)

    abstract override fun <D> transformAnnotations(transformer: FirTransformer<D>, data: D): FirSpreadArgumentExpression
}
