/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

@file:Suppress("DuplicatedCode", "unused")

package ksp.org.jetbrains.kotlin.fir.expressions.builder

import kotlin.contracts.*
import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.DfaType
import ksp.org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder
import ksp.org.jetbrains.kotlin.fir.builder.FirBuilderDsl
import ksp.org.jetbrains.kotlin.fir.builder.toMutableOrEmpty
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression
import ksp.org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSmartCastExpressionImpl
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef
import ksp.org.jetbrains.kotlin.types.SmartcastStability

@FirBuilderDsl
class FirSmartCastExpressionBuilder : FirAnnotationContainerBuilder, FirExpressionBuilder {
    override var coneTypeOrNull: ConeKotlinType? = null
    override val annotations: MutableList<FirAnnotation> = mutableListOf()
    lateinit var originalExpression: FirExpression
    lateinit var upperTypesFromSmartCast: Collection<ConeKotlinType>
    lateinit var lowerTypesFromSmartCast: Collection<DfaType>
    lateinit var smartcastType: FirTypeRef
    var smartcastTypeWithoutNullableNothing: FirTypeRef? = null
    lateinit var smartcastStability: SmartcastStability

    override fun build(): FirSmartCastExpression {
        return FirSmartCastExpressionImpl(
            coneTypeOrNull,
            annotations.toMutableOrEmpty(),
            originalExpression,
            upperTypesFromSmartCast,
            lowerTypesFromSmartCast,
            smartcastType,
            smartcastTypeWithoutNullableNothing,
            smartcastStability,
        )
    }


    @Deprecated("Modification of 'source' has no impact for FirSmartCastExpressionBuilder", level = DeprecationLevel.HIDDEN)
    override var source: KtSourceElement?
        get() = throw IllegalStateException()
        set(_) {
            throw IllegalStateException()
        }
}

@OptIn(ExperimentalContracts::class)
inline fun buildSmartCastExpression(init: FirSmartCastExpressionBuilder.() -> Unit): FirSmartCastExpression {
    contract {
        callsInPlace(init, InvocationKind.EXACTLY_ONCE)
    }
    return FirSmartCastExpressionBuilder().apply(init).build()
}
