/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.resolve

import ksp.org.jetbrains.kotlin.fir.resolve.providers.impl.FirFallbackBuiltinSymbolProvider
import ksp.org.jetbrains.kotlin.fir.resolve.providers.impl.getTopLevelClassifierNamesInPackage
import ksp.org.jetbrains.kotlin.name.StandardClassIds
import ksp.org.jetbrains.kotlin.resolve.DefaultImportProvider
import ksp.org.jetbrains.kotlin.resolve.ImportPath
import ksp.org.jetbrains.kotlin.storage.StorageManager

object FirJvmDefaultImportProvider : DefaultImportProvider() {
    override fun computePlatformSpecificDefaultImports(storageManager: StorageManager, result: MutableList<ImportPath>) {
        result.add(ImportPath.fromString("kotlin.jvm.*"))

        for (builtInsPackage in StandardClassIds.builtInsPackagesWithDefaultNamedImport) {
            getTopLevelClassifierNamesInPackage(FirFallbackBuiltinSymbolProvider.builtInsPackageFragments, builtInsPackage).forEach {
                result.add(ImportPath(builtInsPackage.child(it), false))
            }
        }
    }

    override val defaultLowPriorityImports: List<ImportPath> =
        listOf(ImportPath.fromString("java.lang.*"))
}