/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.resolve.providers

import ksp.org.jetbrains.kotlin.fir.declarations.FirFile
import ksp.org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol
import ksp.org.jetbrains.kotlin.name.ClassId

fun FirProvider.getContainingFile(symbol: FirBasedSymbol<*>): FirFile? = when (symbol) {
    is FirSyntheticFunctionSymbol -> {
        // SAM case
        val classId = ClassId(symbol.callableId.packageName, symbol.callableId.callableName)
        getFirClassifierContainerFileIfAny(classId)
    }
    is FirClassLikeSymbol<*> -> getFirClassifierContainerFileIfAny(symbol)
    is FirCallableSymbol<*> -> getFirCallableContainerFile(symbol)
    else -> null
}
