/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.backend.js.wasm

import ksp.org.jetbrains.kotlin.config.CompilerConfiguration
import ksp.org.jetbrains.kotlin.ir.IrDiagnosticReporter
import ksp.org.jetbrains.kotlin.ir.IrElement
import ksp.org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext
import ksp.org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExportingDeclaration
import ksp.org.jetbrains.kotlin.ir.backend.js.wasm.declarations.WasmKlibExportsChecker
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorVoid
import ksp.org.jetbrains.kotlin.ir.visitors.acceptChildrenVoid
import ksp.org.jetbrains.kotlin.library.SerializedIrFile

object WasmKlibCheckers {

    fun makeChecker(
        diagnosticReporter: IrDiagnosticReporter,
        configuration: CompilerConfiguration,
        cleanFiles: List<SerializedIrFile> = listOf(),
        exportedNames: Map<IrFile, Map<IrDeclarationWithName, String>> = mapOf(),
    ): IrVisitorVoid {
        return object : IrVisitorVoid() {
            private val diagnosticContext = JsKlibDiagnosticContext(configuration)

            override fun visitModuleFragment(declaration: IrModuleFragment) {
                val exportedDeclarations = JsKlibExportingDeclaration.collectDeclarations(cleanFiles, declaration.files, exportedNames)
                WasmKlibExportsChecker.check(exportedDeclarations, this.diagnosticContext, diagnosticReporter)
            }
        }
    }
}