// Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

package ksp.org.jetbrains.kotlin.js.backend.ast;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JsExpressionStatement extends AbstractNode implements JsStatement {
    @NotNull
    private JsExpression expression;

    public JsExpressionStatement(@NotNull JsExpression expression) {
        this.expression = expression;
    }

    @NotNull
    public JsExpression getExpression() {
        return expression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitExpressionStatement(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.accept(expression);
    }

    @Nullable
    @Override
    public JsLocationWithSource getSource() {
        return null;
    }

    @Override
    public void setSource(@Nullable JsLocationWithSource info) {
        throw new IllegalStateException("You must not set source info for JsExpressionStatement, set for expression");
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            expression = v.accept(expression);
        }
        v.endVisit(this, ctx);
    }

    @NotNull
    @Override
    public JsExpressionStatement deepCopy() {
        return new JsExpressionStatement(expression.deepCopy()).withMetadataFrom(this);
    }
}
