/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.light.classes.symbol.parameters

import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer
import ksp.org.jetbrains.kotlin.asJava.classes.lazyPub
import ksp.org.jetbrains.kotlin.light.classes.symbol.NullabilityAnnotation
import ksp.org.jetbrains.kotlin.light.classes.symbol.isLateInit
import ksp.org.jetbrains.kotlin.light.classes.symbol.methods.SymbolLightMethodBase
import ksp.org.jetbrains.kotlin.light.classes.symbol.withSymbol
import ksp.org.jetbrains.kotlin.name.SpecialNames

internal class SymbolLightSetterParameter(
    private val containingPropertySymbolPointer: KaSymbolPointer<KaPropertySymbol>,
    parameterSymbol: KaValueParameterSymbol,
    containingMethod: SymbolLightMethodBase,
) : SymbolLightParameterCommon(parameterSymbol, containingMethod) {
    override fun getName(): String {
        if (isDefaultSetterParameter) return SpecialNames.IMPLICIT_SET_PARAMETER.asString()
        return super.getName()
    }

    private val isDefaultSetterParameter: Boolean by lazyPub {
        containingPropertySymbolPointer.withSymbol(ktModule) {
            it.setter?.isNotDefault != true
        }
    }

    override fun typeNullability(): NullabilityAnnotation {
        val isLateInit = containingPropertySymbolPointer.withSymbol(ktModule) { it.isLateInit }
        return if (isLateInit) NullabilityAnnotation.NON_NULLABLE else super.typeNullability()
    }

    override fun isDeclaredAsVararg(): Boolean = false

    override fun isVarArgs() = false
}
