/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.load.java.components

import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings

object JavaDeprecationSettings : DeprecationSettings {
    override fun propagatedToOverrides(deprecationAnnotation: AnnotationDescriptor): Boolean {
        if (deprecationAnnotation is JavaDeprecatedAnnotationDescriptor) return false
        return true
    }
}
