/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.platform

import ksp.org.jetbrains.kotlin.platform.js.JsPlatforms.allJsPlatforms
import ksp.org.jetbrains.kotlin.platform.js.JsPlatforms.defaultJsPlatform
import ksp.org.jetbrains.kotlin.platform.jvm.JvmPlatforms.allJvmPlatforms
import ksp.org.jetbrains.kotlin.platform.jvm.JvmPlatforms.unspecifiedJvmPlatform
import ksp.org.jetbrains.kotlin.platform.konan.NativePlatforms.allNativePlatforms
import ksp.org.jetbrains.kotlin.platform.konan.NativePlatforms.unspecifiedNativePlatform
import ksp.org.jetbrains.kotlin.platform.wasm.WasmPlatforms
import ksp.org.jetbrains.kotlin.platform.wasm.WasmPlatforms.allWasmPlatforms

@Suppress("DEPRECATION_ERROR")
object CommonPlatforms {

    @Deprecated(
        message = "Should be accessed only by compatibility layer, other clients should use 'unspecifiedJvmPlatform'",
        level = DeprecationLevel.ERROR
    )
    object CompatCommonPlatform : TargetPlatform(
        setOf(
            unspecifiedJvmPlatform.single(),
            defaultJsPlatform.single(),
            WasmPlatforms.wasmJs.single(),
            WasmPlatforms.wasmWasi.single(),
            unspecifiedNativePlatform.single()
        )
    ), org.jetbrains.kotlin.analyzer.common.CommonPlatform {
        override val platformName: String
            get() = "Default"
    }

    val defaultCommonPlatform: TargetPlatform
        get() = CompatCommonPlatform

    val allSimplePlatforms: List<TargetPlatform>
        // TODO(auskov): migrate to SimplePlatform?
        get() = sequence {
            yieldAll(allJvmPlatforms)
            yieldAll(allNativePlatforms)
            yieldAll(allJsPlatforms)
            yieldAll(allWasmPlatforms)

            // TODO(dsavvinov): extensions points?
        }.toList()

    val allDefaultTargetPlatforms: List<TargetPlatform>
        get() = sequence {
            yieldAll(allSimplePlatforms)
            yieldAll(listOf(defaultCommonPlatform))
        }.toList()
}

