/*
 * Copyright 2010-2021 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.resolve.extensions

import ksp.com.intellij.openapi.project.Project
import ksp.org.jetbrains.kotlin.analyzer.AnalysisResult
import ksp.org.jetbrains.kotlin.container.ComponentProvider
import ksp.org.jetbrains.kotlin.context.ProjectContext
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor
import ksp.org.jetbrains.kotlin.extensions.ProjectExtensionDescriptor
import ksp.org.jetbrains.kotlin.psi.KtFile
import ksp.org.jetbrains.kotlin.resolve.BindingTrace

interface AnalysisHandlerExtension {
    companion object : ProjectExtensionDescriptor<AnalysisHandlerExtension>(
        "org.jetbrains.kotlin.analyzeCompleteHandlerExtension",
        AnalysisHandlerExtension::class.java
    )

    fun doAnalysis(
        project: Project,
        module: ModuleDescriptor,
        projectContext: ProjectContext,
        files: Collection<KtFile>,
        bindingTrace: BindingTrace,
        componentProvider: ComponentProvider
    ): AnalysisResult? = null

    fun analysisCompleted(
        project: Project,
        module: ModuleDescriptor,
        bindingTrace: BindingTrace,
        files: Collection<KtFile>
    ): AnalysisResult? = null
}