package com.google.devtools.ksp.standalone

import ksp.com.intellij.core.CoreApplicationEnvironment
import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinCompositeDeclarationProvider
import ksp.org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProvider
import ksp.org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactory
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule
import ksp.org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProviderFactory
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject
import ksp.org.jetbrains.kotlin.psi.KtFile
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias

class IncrementalKotlinDeclarationProviderFactory(
    private val project: Project,
    private val environment: CoreApplicationEnvironment,
) : KotlinDeclarationProviderFactory {
    private val staticFactories: MutableList<KotlinStandaloneDeclarationProviderFactory> = mutableListOf()

    override fun createDeclarationProvider(
        scope: GlobalSearchScope,
        contextualModule: KaModule?
    ): KotlinDeclarationProvider {
        val providers = staticFactories.map { it.createDeclarationProvider(scope, contextualModule) }
        return KotlinCompositeDeclarationProvider.create(providers)
    }

    fun update(files: Collection<KtFile>) {
        val skipBuiltIns = staticFactories.isNotEmpty()
        val staticFactory = KotlinStandaloneDeclarationProviderFactory(
            project,
            environment,
            files,
            skipBuiltins = skipBuiltIns
        )
        staticFactories.add(staticFactory)
    }

    fun getDirectInheritorCandidates(baseClassName: Name): Set<KtClassOrObject> =
        staticFactories.flatMapTo(mutableSetOf()) {
            it.getDirectInheritorCandidates(baseClassName)
        }

    fun getInheritableTypeAliases(aliasedName: Name): Set<KtTypeAlias> =
        staticFactories.flatMapTo(mutableSetOf()) {
            it.getInheritableTypeAliases(aliasedName)
        }
}
