// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * @author Medvedev Max
 */
public final class JVMElementFactories extends LanguageExtension<JVMElementFactoryProvider> {
  private static final JVMElementFactories INSTANCE = new JVMElementFactories();

  private JVMElementFactories() {
    super("com.intellij.generation.topLevelFactory");
  }

  public static @Nullable JVMElementFactory getFactory(@NotNull Language language, @NotNull Project project) {
    final JVMElementFactoryProvider provider = INSTANCE.forLanguage(language);
    return provider != null? provider.getFactory(project) : null;
  }

  public static @NotNull JVMElementFactory requireFactory(@NotNull Language language, @NotNull Project project) {
    final JVMElementFactory factory = getFactory(language, project);
    assert factory != null : language;
    return factory;
  }
}
