// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.jvm.JvmTypeParametersOwner;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * Represents a PSI element (class, interface, method or constructor) which can own a type
 * parameter list.
 */
public interface PsiTypeParameterListOwner extends PsiJvmMember, JvmTypeParametersOwner {
  /**
   * Checks if the element has any type parameters.
   *
   * @return true if the element has type parameters, false otherwise
   */
  boolean hasTypeParameters();

  /**
   * Returns the type parameter list for the element.
   *
   * @return the type parameter list, or null if the element has no type parameters.
   */
  @Nullable
  PsiTypeParameterList getTypeParameterList();

  /**
   * Returns the array of type parameters for the element.
   *
   * @return the array of type parameters, or an empty array if the element has no type parameters.
   */
  @Override
  PsiTypeParameter @NotNull [] getTypeParameters();
}
