/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.references

import ksp.org.jetbrains.kotlin.idea.references.ReadWriteAccessChecker
import ksp.org.jetbrains.kotlin.idea.references.mainReference
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression
import ksp.org.jetbrains.kotlin.psi.KtExpression
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction
import ksp.org.jetbrains.kotlin.resolve.references.ReferenceAccess
import ksp.org.jetbrains.kotlin.types.expressions.OperatorConventions

internal class ReadWriteAccessCheckerFirImpl : ReadWriteAccessChecker {
    override fun readWriteAccessWithFullExpressionByResolve(assignment: KtBinaryExpression): Pair<ReferenceAccess, KtExpression>? {
        val function = assignment.operationReference.mainReference.resolve() as? KtNamedFunction ?: return null
        val name = function.name ?: return null
        return if (Name.identifier(name) in OperatorConventions.ASSIGNMENT_OPERATIONS.values)
            ReferenceAccess.READ to assignment
        else
            null
    }
}
