/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.elements

import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.psi.stubs.StubInputStream
import ksp.com.intellij.psi.stubs.StubOutputStream
import ksp.org.jetbrains.annotations.NonNls
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderWithTextStub
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderWithTextStubImpl

class KtPlaceHolderWithTextStubElementType<T : KtElementImplStub<out StubElement<*>>>(@NonNls debugName: String, psiClass: Class<T>) :
    KtStubElementType<KotlinPlaceHolderWithTextStubImpl<T>, T>(
        debugName,
        psiClass,
        KotlinPlaceHolderWithTextStub::class.java,
    ) {

    override fun createStub(psi: T, parentStub: StubElement<*>): KotlinPlaceHolderWithTextStubImpl<T> {
        return KotlinPlaceHolderWithTextStubImpl(parentStub, this, psi.text)
    }

    override fun serialize(stub: KotlinPlaceHolderWithTextStubImpl<T>, dataStream: StubOutputStream) {
        dataStream.writeUTFFast(stub.text)
    }

    override fun deserialize(dataStream: StubInputStream, parentStub: StubElement<*>): KotlinPlaceHolderWithTextStubImpl<T> {
        val text = dataStream.readUTFFast()
        return KotlinPlaceHolderWithTextStubImpl(parentStub, this, text)
    }
}
