/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.gradle.utils;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.google.devtools.ksp.gradle.utils.KgpUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\b"}, d2={"canUseAddGeneratedSourceDirectoriesApi", "", "Lorg/gradle/api/Project;", "canUseInternalKspApis", "getAgpVersion", "Lcom/android/build/api/AndroidPluginVersion;", "isAgpBuiltInKotlinUsed", "useLegacyVariantApi", "gradle-plugin"})
public final class AgpUtilsKt {
    @Nullable
    public static final AndroidPluginVersion getAgpVersion(@NotNull Project $this$getAgpVersion) {
        AndroidComponentsExtension androidComponentsExtension;
        Intrinsics.checkNotNullParameter((Object)$this$getAgpVersion, (String)"<this>");
        try {
            androidComponentsExtension = (AndroidComponentsExtension)$this$getAgpVersion.getExtensions().findByType(AndroidComponentsExtension.class);
            androidComponentsExtension = androidComponentsExtension != null ? androidComponentsExtension.getPluginVersion() : null;
        }
        catch (NoClassDefFoundError e) {
            androidComponentsExtension = null;
        }
        catch (Exception e) {
            androidComponentsExtension = null;
        }
        return androidComponentsExtension;
    }

    public static final boolean isAgpBuiltInKotlinUsed(@NotNull Project $this$isAgpBuiltInKotlinUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$isAgpBuiltInKotlinUsed, (String)"<this>");
        return KgpUtilsKt.isKotlinBaseApiPluginApplied($this$isAgpBuiltInKotlinUsed) && !KgpUtilsKt.isKotlinAndroidPluginApplied($this$isAgpBuiltInKotlinUsed);
    }

    public static final boolean useLegacyVariantApi(@NotNull Project $this$useLegacyVariantApi) {
        Intrinsics.checkNotNullParameter((Object)$this$useLegacyVariantApi, (String)"<this>");
        Project project = $this$useLegacyVariantApi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return true;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(8, 10, 0).alpha(3)) < 0;
    }

    public static final boolean canUseAddGeneratedSourceDirectoriesApi(@NotNull Project $this$canUseAddGeneratedSourceDirectoriesApi) {
        Intrinsics.checkNotNullParameter((Object)$this$canUseAddGeneratedSourceDirectoriesApi, (String)"<this>");
        Project project = $this$canUseAddGeneratedSourceDirectoriesApi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return false;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(8, 12, 0).alpha(6)) >= 0;
    }

    public static final boolean canUseInternalKspApis(@NotNull Project $this$canUseInternalKspApis) {
        Intrinsics.checkNotNullParameter((Object)$this$canUseInternalKspApis, (String)"<this>");
        Project project = $this$canUseInternalKspApis.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return false;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(9, 0, 0).alpha(14)) >= 0;
    }
}

