/*
 * Copyright 2022 Google LLC
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.devtools.ksp.impl

import com.intellij.mock.MockProject
import com.intellij.psi.PsiDocumentManager

class KSPCoreEnvironment(internal val project: MockProject) {
    companion object {
        // TODO: get rid of singleton.
        val instance_prop: ThreadLocal<KSPCoreEnvironment> = ThreadLocal()

        var instance: KSPCoreEnvironment
            get() = instance_prop.get()
            set(value) {
                instance_prop.set(value)
            }
    }
    init {
        instance = this
    }
    val psiDocumentManager = PsiDocumentManager.getInstance(project)
}
