/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaug;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public class zzatb
extends zzaug {
    private final Map<String, Long> zzbqp;
    private final Map<String, Integer> zzbqq = new ArrayMap();
    private long zzbqr;

    public zzatb(zzaue zzaue2) {
        super(zzaue2);
        this.zzbqp = new ArrayMap();
    }

    public void beginAdUnitExposure(final String string) {
        if (string == null || string.length() == 0) {
            this.zzKk().zzLX().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznR().elapsedRealtime();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzf(string, l);
            }
        });
    }

    @WorkerThread
    private void zzf(String string, long l) {
        Integer n;
        this.zzJV();
        this.zzmR();
        zzac.zzdr((String)string);
        if (this.zzbqq.isEmpty()) {
            this.zzbqr = l;
        }
        if ((n = this.zzbqq.get(string)) != null) {
            this.zzbqq.put(string, n + 1);
        } else {
            if (this.zzbqq.size() >= 100) {
                this.zzKk().zzLZ().log("Too many ads visible");
                return;
            }
            this.zzbqq.put(string, 1);
            this.zzbqp.put(string, l);
        }
    }

    public void endAdUnitExposure(final String string) {
        if (string == null || string.length() == 0) {
            this.zzKk().zzLX().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznR().elapsedRealtime();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzg(string, l);
            }
        });
    }

    @WorkerThread
    private void zzg(String string, long l) {
        this.zzJV();
        this.zzmR();
        zzac.zzdr((String)string);
        Integer n = this.zzbqq.get(string);
        if (n != null) {
            zzauk.zza zza2 = this.zzKd().zzMT();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbqq.remove(string);
                Long l2 = this.zzbqp.get(string);
                if (l2 == null) {
                    this.zzKk().zzLX().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzbqp.remove(string);
                    this.zza(string, l3, zza2);
                }
                if (this.zzbqq.isEmpty()) {
                    if (this.zzbqr == 0L) {
                        this.zzKk().zzLX().log("First ad exposure time was never set");
                    } else {
                        this.zza(l - this.zzbqr, zza2);
                        this.zzbqr = 0L;
                    }
                }
            } else {
                this.zzbqq.put(string, n2);
            }
        } else {
            this.zzKk().zzLX().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
        }
    }

    @WorkerThread
    private void zza(long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzKk().zzMd().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzKk().zzMd().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzauk.zza(zzf2, bundle);
        this.zzJZ().zze("am", "_xa", bundle);
    }

    @WorkerThread
    private void zza(String string, long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzKk().zzMd().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzKk().zzMd().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzauk.zza(zzf2, bundle);
        this.zzJZ().zze("am", "_xu", bundle);
    }

    @WorkerThread
    public void zzW(long l) {
        zzauk.zza zza2 = this.zzKd().zzMT();
        for (String string : this.zzbqp.keySet()) {
            long l2 = this.zzbqp.get(string);
            this.zza(string, l - l2, zza2);
        }
        if (!this.zzbqp.isEmpty()) {
            this.zza(l - this.zzbqr, zza2);
        }
        this.zzX(l);
    }

    public void zzJT() {
        final long l = this.zznR().elapsedRealtime();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzX(l);
            }
        });
    }

    @WorkerThread
    private void zzX(long l) {
        for (String string : this.zzbqp.keySet()) {
            this.zzbqp.put(string, l);
        }
        if (!this.zzbqp.isEmpty()) {
            this.zzbqr = l;
        }
    }
}

