/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class zzaud
extends zzauh {
    private ExecutorService zzbtM;
    private zzd zzbtN;
    private zzd zzbtO;
    private final PriorityBlockingQueue<FutureTask<?>> zzbtP;
    private final BlockingQueue<FutureTask<?>> zzbtQ;
    private final Thread.UncaughtExceptionHandler zzbtR;
    private final Thread.UncaughtExceptionHandler zzbtS;
    private final Object zzbtT = new Object();
    private final Semaphore zzbtU = new Semaphore(2);
    private volatile boolean zzbtV;
    private static final AtomicLong zzbtW = new AtomicLong(Long.MIN_VALUE);

    zzaud(zzaue zzaue2) {
        super(zzaue2);
        this.zzbtP = new PriorityBlockingQueue();
        this.zzbtQ = new LinkedBlockingQueue();
        this.zzbtR = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzbtS = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzmS() {
    }

    @Override
    public void zzmR() {
        if (Thread.currentThread() != this.zzbtN) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzJW() {
        if (Thread.currentThread() != this.zzbtO) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public boolean zzbc() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public boolean zzMp() {
        return Thread.currentThread() == this.zzbtN;
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzob();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbtN) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzob();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbtN) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzob();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.zzbtT;
        synchronized (object) {
            this.zzbtP.add(zzc2);
            if (this.zzbtN == null) {
                this.zzbtN = new zzd("Measurement Worker", this.zzbtP);
                this.zzbtN.setUncaughtExceptionHandler(this.zzbtR);
                this.zzbtN.start();
            } else {
                this.zzbtN.zzhA();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zzob();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzbtT;
        synchronized (object) {
            this.zzbtQ.add(futureTask);
            if (this.zzbtO == null) {
                this.zzbtO = new zzd("Measurement Network", this.zzbtQ);
                this.zzbtO.setUncaughtExceptionHandler(this.zzbtS);
                this.zzbtO.start();
            } else {
                this.zzbtO.zzhA();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService zzMq() {
        Object object = this.zzbtT;
        synchronized (object) {
            if (this.zzbtM == null) {
                this.zzbtM = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzbtM;
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzbtX;

        public zzb(String string) {
            zzac.zzw((Object)string);
            this.zzbtX = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzaud.this.zzKk().zzLX().zzj(this.zzbtX, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long zzbtZ;
        private final boolean zzbua;
        private final String zzbtX;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzac.zzw((Object)string);
            this.zzbtZ = zzbtW.getAndIncrement();
            this.zzbtX = string;
            this.zzbua = bl;
            if (this.zzbtZ == Long.MAX_VALUE) {
                zzaud.this.zzKk().zzLX().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzac.zzw((Object)string);
            this.zzbtZ = zzbtW.getAndIncrement();
            this.zzbtX = string;
            this.zzbua = bl;
            if (this.zzbtZ == Long.MAX_VALUE) {
                zzaud.this.zzKk().zzLX().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzaud.this.zzKk().zzLX().zzj(this.zzbtX, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(@NonNull zzc zzc2) {
            if (this.zzbua != zzc2.zzbua) {
                return this.zzbua ? -1 : 1;
            }
            if (this.zzbtZ < zzc2.zzbtZ) {
                return -1;
            }
            if (this.zzbtZ > zzc2.zzbtZ) {
                return 1;
            }
            zzaud.this.zzKk().zzLY().zzj("Two tasks share the same index. index", this.zzbtZ);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(@NonNull Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object zzbub;
        private final BlockingQueue<FutureTask<?>> zzbuc;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzac.zzw((Object)string);
            zzac.zzw(blockingQueue);
            this.zzbub = new Object();
            this.zzbuc = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzaud.this.zzbtU.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.zzbuc.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.zzbub;
                    synchronized (object) {
                        if (this.zzbuc.peek() == null && !zzaud.this.zzbtV) {
                            try {
                                this.zzbub.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzaud.this.zzbtT;
                    synchronized (object) {
                        if (this.zzbuc.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzaud.this.zzbtT;
                synchronized (object) {
                    zzaud.this.zzbtU.release();
                    zzaud.this.zzbtT.notifyAll();
                    if (this == zzaud.this.zzbtN) {
                        zzaud.this.zzbtN = null;
                    } else if (this == zzaud.this.zzbtO) {
                        zzaud.this.zzbtO = null;
                    } else {
                        zzaud.this.zzKk().zzLX().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzhA() {
            Object object = this.zzbub;
            synchronized (object) {
                this.zzbub.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzaud.this.zzKk().zzLZ().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

