/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzatk;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzatt;
import com.google.android.gms.internal.zzatw;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzauo;
import com.google.android.gms.internal.zzauq;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzaul
extends zzauh {
    private final zza zzbvE;
    private zzatt zzbvF;
    private Boolean zzbvG;
    private final zzatk zzbvH;
    private final zzauo zzbvI;
    private final List<Runnable> zzbvJ = new ArrayList<Runnable>();
    private final zzatk zzbvK;

    protected zzaul(zzaue zzaue2) {
        super(zzaue2);
        this.zzbvI = new zzauo(zzaue2.zznR());
        this.zzbvE = new zza();
        this.zzbvH = new zzatk(zzaue2){

            @Override
            public void run() {
                zzaul.this.zzop();
            }
        };
        this.zzbvK = new zzatk(zzaue2){

            @Override
            public void run() {
                zzaul.this.zzKk().zzLZ().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzmS() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzmR();
        this.zzob();
        return this.zzbvF != null;
    }

    @WorkerThread
    protected void zzMV() {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvF;
                if (zzatt2 == null) {
                    zzaul.this.zzKk().zzLX().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzatt2.zzb(zzaul.this.zzKa().zzfD(zzaul.this.zzKk().zzMe()));
                    zzaul.this.zzoo();
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKk().zzLX().zzj("Failed to send measurementEnabled to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    void zza(zzatt zzatt2, com.google.android.gms.common.internal.safeparcel.zza zza2) {
        this.zzmR();
        this.zzJV();
        this.zzob();
        this.zzKm().zzLf();
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        int n = 100;
        this.zzKm().zzLo();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<com.google.android.gms.common.internal.safeparcel.zza> list = this.zzKe().zzlD(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zza2 != null && n < 100) {
                arrayList.add(zza2);
            }
            for (com.google.android.gms.common.internal.safeparcel.zza zza3 : arrayList) {
                if (zza3 instanceof zzatq) {
                    try {
                        zzatt2.zza((zzatq)zza3, this.zzKa().zzfD(this.zzKk().zzMe()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzKk().zzLX().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzauq) {
                    try {
                        zzatt2.zza((zzauq)zza3, this.zzKa().zzfD(this.zzKk().zzMe()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzKk().zzLX().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzatg) {
                    try {
                        zzatt2.zza((zzatg)zza3, this.zzKa().zzfD(this.zzKk().zzMe()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzKk().zzLX().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                this.zzKk().zzLX().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected void zzc(zzatq zzatq2, String string) {
        zzac.zzw((Object)((Object)zzatq2));
        this.zzmR();
        this.zzob();
        this.zzKm().zzLf();
        boolean bl = this.zzKe().zza(zzatq2);
        this.zzo(new Runnable(true, bl, zzatq2, string){
            final /* synthetic */ boolean zzbvO;
            final /* synthetic */ boolean zzbvP;
            final /* synthetic */ zzatq zzbuU;
            final /* synthetic */ String zzbla;
            {
                this.zzbvO = bl;
                this.zzbvP = bl2;
                this.zzbuU = zzatq2;
                this.zzbla = string;
            }

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvF;
                if (zzatt2 == null) {
                    zzaul.this.zzKk().zzLX().log("Discarding data. Failed to send event to service");
                    return;
                }
                if (this.zzbvO) {
                    zzaul.this.zza(zzatt2, this.zzbvP ? null : this.zzbuU);
                } else {
                    try {
                        if (TextUtils.isEmpty((CharSequence)this.zzbla)) {
                            zzatt2.zza(this.zzbuU, zzaul.this.zzKa().zzfD(zzaul.this.zzKk().zzMe()));
                        } else {
                            zzatt2.zza(this.zzbuU, this.zzbla, zzaul.this.zzKk().zzMe());
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKk().zzLX().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                }
                zzaul.this.zzoo();
            }
        });
    }

    @WorkerThread
    protected void zzf(zzatg zzatg2) {
        zzac.zzw((Object)((Object)zzatg2));
        this.zzmR();
        this.zzob();
        this.zzKm().zzLf();
        boolean bl = this.zzKe().zzc(zzatg2);
        zzatg zzatg3 = new zzatg(zzatg2);
        this.zzo(new Runnable(true, bl, zzatg3, zzatg2){
            final /* synthetic */ boolean zzbvO;
            final /* synthetic */ boolean zzbvP;
            final /* synthetic */ zzatg zzbvQ;
            final /* synthetic */ zzatg zzbvR;
            {
                this.zzbvO = bl;
                this.zzbvP = bl2;
                this.zzbvQ = zzatg2;
                this.zzbvR = zzatg3;
            }

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvF;
                if (zzatt2 == null) {
                    zzaul.this.zzKk().zzLX().log("Discarding data. Failed to send conditional user property to service");
                    return;
                }
                if (this.zzbvO) {
                    zzaul.this.zza(zzatt2, this.zzbvP ? null : this.zzbvQ);
                } else {
                    try {
                        if (TextUtils.isEmpty((CharSequence)this.zzbvR.packageName)) {
                            zzatt2.zza(this.zzbvQ, zzaul.this.zzKa().zzfD(zzaul.this.zzKk().zzMe()));
                        } else {
                            zzatt2.zzb(this.zzbvQ);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKk().zzLX().zzj("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                }
                zzaul.this.zzoo();
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzatg>> atomicReference, final String string, final String string2, final String string3) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvF;
                        if (zzatt2 == null) {
                            zzaul.this.zzKk().zzLX().zzd("Failed to get conditional properties", zzatx.zzfE(string), string2, string3);
                            atomicReference.set(Collections.emptyList());
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            atomicReference.set(zzatt2.zza(string2, string3, zzaul.this.zzKa().zzfD(zzaul.this.zzKk().zzMe())));
                        } else {
                            atomicReference.set(zzatt2.zzn(string, string2, string3));
                        }
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKk().zzLX().zzd("Failed to get conditional properties", zzatx.zzfE(string), string2, (Object)remoteException);
                        atomicReference.set(Collections.emptyList());
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzauq>> atomicReference, final String string, final String string2, final String string3, final boolean bl) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvF;
                        if (zzatt2 == null) {
                            zzaul.this.zzKk().zzLX().zzd("Failed to get user properties", zzatx.zzfE(string), string2, string3);
                            atomicReference.set(Collections.emptyList());
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            atomicReference.set(zzatt2.zza(string2, string3, bl, zzaul.this.zzKa().zzfD(zzaul.this.zzKk().zzMe())));
                        } else {
                            atomicReference.set(zzatt2.zza(string, string2, string3, bl));
                        }
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKk().zzLX().zzd("Failed to get user properties", zzatx.zzfE(string), string2, (Object)remoteException);
                        atomicReference.set(Collections.emptyList());
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzb(final zzauq zzauq2) {
        this.zzmR();
        this.zzob();
        this.zzKm().zzLf();
        final boolean bl = this.zzKe().zza(zzauq2);
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvF;
                if (zzatt2 == null) {
                    zzaul.this.zzKk().zzLX().log("Discarding data. Failed to set user attribute");
                    return;
                }
                zzaul.this.zza(zzatt2, bl ? null : zzauq2);
                zzaul.this.zzoo();
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzauq>> atomicReference, final boolean bl) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvF;
                        if (zzatt2 == null) {
                            zzaul.this.zzKk().zzLX().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzatt2.zza(zzaul.this.zzKa().zzfD(null), bl));
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKk().zzLX().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    public void zza(final AtomicReference<String> atomicReference) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvF;
                        if (zzatt2 == null) {
                            zzaul.this.zzKk().zzLX().log("Failed to get app instance id");
                            return;
                        }
                        atomicReference.set(zzatt2.zzc(zzaul.this.zzKa().zzfD(null)));
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKk().zzLX().zzj("Failed to get app instance id", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzMQ() {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvF;
                if (zzatt2 == null) {
                    zzaul.this.zzKk().zzLX().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzatt2.zza(zzaul.this.zzKa().zzfD(zzaul.this.zzKk().zzMe()));
                    zzaul.this.zza(zzatt2, null);
                    zzaul.this.zzoo();
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKk().zzLX().zzj("Failed to send app launch to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AppMeasurement.zzf zzf2) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvF;
                if (zzatt2 == null) {
                    zzaul.this.zzKk().zzLX().log("Failed to send current screen to service");
                    return;
                }
                try {
                    if (zzf2 == null) {
                        zzatt2.zza(0L, null, null, zzaul.this.getContext().getPackageName());
                    } else {
                        zzatt2.zza(zzf2.zzbql, zzf2.zzbqj, zzf2.zzbqk, zzaul.this.getContext().getPackageName());
                    }
                    zzaul.this.zzoo();
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKk().zzLX().zzj("Failed to send current screen to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzoo() {
        this.zzmR();
        this.zzbvI.start();
        this.zzbvH.zzy(this.zzKm().zzpq());
    }

    @WorkerThread
    void zzoD() {
        this.zzmR();
        this.zzob();
        if (this.isConnected()) {
            return;
        }
        if (this.zzbvG == null) {
            this.zzbvG = this.zzKl().zzMl();
            if (this.zzbvG == null) {
                this.zzKk().zzMd().log("State of service unknown");
                this.zzbvG = this.zzMX();
                this.zzKl().zzaK(this.zzbvG);
            }
        }
        if (this.zzbvG.booleanValue()) {
            this.zzKk().zzMd().log("Using measurement service");
            this.zzbvE.zzNa();
        } else {
            if (this.zzMW()) {
                this.zzKk().zzMd().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                Context context = this.getContext();
                this.zzKm().zzLf();
                intent.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzbvE.zzC(intent);
                return;
            }
            this.zzKk().zzLX().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    private boolean zzMW() {
        this.zzKm().zzLf();
        PackageManager packageManager = this.getContext().getPackageManager();
        Intent intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzMX() {
        this.zzmR();
        this.zzob();
        this.zzKm().zzLf();
        this.zzKk().zzMd().log("Checking service availability");
        int n = zze.zzuY().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzKk().zzMd().log("Service available");
                return true;
            }
            case 1: {
                this.zzKk().zzMd().log("Service missing");
                return false;
            }
            case 18: {
                this.zzKk().zzLZ().log("Service updating");
                return true;
            }
            case 2: {
                this.zzKk().zzMc().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzKk().zzLZ().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzKk().zzLZ().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    protected void zza(zzatt zzatt2) {
        this.zzmR();
        zzac.zzw((Object)zzatt2);
        this.zzbvF = zzatt2;
        this.zzoo();
        this.zzMZ();
    }

    @WorkerThread
    public void disconnect() {
        this.zzmR();
        this.zzob();
        try {
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyJ();
            zza2.zza(this.getContext(), (ServiceConnection)this.zzbvE);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzbvF = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzmR();
        if (this.zzbvF != null) {
            this.zzbvF = null;
            this.zzKk().zzMd().zzj("Disconnected from device MeasurementService", componentName);
            this.zzMY();
        }
    }

    @WorkerThread
    private void zzop() {
        this.zzmR();
        if (!this.isConnected()) {
            return;
        }
        this.zzKk().zzMd().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private void zzMY() {
        this.zzmR();
        this.zzoD();
    }

    @WorkerThread
    private void zzo(Runnable runnable) throws IllegalStateException {
        this.zzmR();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzbvJ.size() >= this.zzKm().zzLl()) {
                this.zzKk().zzLX().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzbvJ.add(runnable);
            this.zzbvK.zzy(60000L);
            this.zzoD();
        }
    }

    @WorkerThread
    private void zzMZ() {
        this.zzmR();
        this.zzKk().zzMd().zzj("Processing queued up service tasks", this.zzbvJ.size());
        for (Runnable runnable : this.zzbvJ) {
            this.zzKj().zzm(runnable);
        }
        this.zzbvJ.clear();
        this.zzbvK.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zzf.zzb,
    zzf.zzc {
        private volatile boolean zzbvS;
        private volatile zzatw zzbvT;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzC(Intent intent) {
            zzaul.this.zzmR();
            Context context = zzaul.this.getContext();
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyJ();
            zza zza3 = this;
            synchronized (zza3) {
                if (this.zzbvS) {
                    zzaul.this.zzKk().zzMd().log("Connection attempt already in progress");
                    return;
                }
                this.zzbvS = true;
                zza2.zza(context, intent, (ServiceConnection)zzaul.this.zzbvE, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzdj((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.zzbvS = false;
                    zzaul.this.zzKk().zzLX().log("Service connected with null binder");
                    return;
                }
                zzatt zzatt2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzatt2 = zzatt.zza.zzes(iBinder);
                        zzaul.this.zzKk().zzMd().log("Bound to IMeasurementService interface");
                    } else {
                        zzaul.this.zzKk().zzLX().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKk().zzLX().log("Service connect failed to get IMeasurementService");
                }
                if (zzatt2 == null) {
                    this.zzbvS = false;
                    try {
                        com.google.android.gms.common.stats.zza.zzyJ().zza(zzaul.this.getContext(), (ServiceConnection)zzaul.this.zzbvE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzatt2;
                    zzaul.this.zzKj().zzm(new Runnable((zzatt)object){
                        final /* synthetic */ zzatt zzbvU;
                        {
                            this.zzbvU = zzatt2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbvS = false;
                                if (!zzaul.this.isConnected()) {
                                    zzaul.this.zzKk().zzMd().log("Connected to service");
                                    zzaul.this.zza(this.zzbvU);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            zzac.zzdj((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzaul.this.zzKk().zzMc().log("Service disconnected");
            zzaul.this.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzaul.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzNa() {
            zzaul.this.zzmR();
            Context context = zzaul.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzbvS) {
                    zzaul.this.zzKk().zzMd().log("Connection attempt already in progress");
                    return;
                }
                if (this.zzbvT != null) {
                    zzaul.this.zzKk().zzMd().log("Already awaiting connection attempt");
                    return;
                }
                this.zzbvT = new zzatw(context, Looper.getMainLooper(), this, this);
                zzaul.this.zzKk().zzMd().log("Connecting to remote service");
                this.zzbvS = true;
                this.zzbvT.zzxz();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            zzac.zzdj((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzatt zzatt2 = (zzatt)this.zzbvT.zzxD();
                    this.zzbvT = null;
                    zzaul.this.zzKj().zzm(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbvS = false;
                                if (!zzaul.this.isConnected()) {
                                    zzaul.this.zzKk().zzMc().log("Connected to remote service");
                                    zzaul.this.zza(zzatt2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzbvT = null;
                    this.zzbvS = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            zzac.zzdj((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzaul.this.zzKk().zzMc().log("Service connection suspended");
            zzaul.this.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzaul zzaul2 = zzaul.this;
                    Context context = zzaul.this.getContext();
                    zzaul.this.zzKm().zzLf();
                    zzaul2.onServiceDisconnected(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzac.zzdj((String)"MeasurementServiceConnection.onConnectionFailed");
            zzatx zzatx2 = zzaul.this.zzbqg.zzMt();
            if (zzatx2 != null) {
                zzatx2.zzLZ().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.zzbvS = false;
                this.zzbvT = null;
            }
        }
    }
}

